Independence_NCDC <- function(NCDC){
  library(IRanges)
  
  NCDC$Begin_Date <- as.numeric(NCDC$Begin_Date)
  NCDC$End_Date <- as.numeric(NCDC$End_Date)
  
  Overlap <- IRanges((NCDC$Begin_Date), NCDC$End_Date)
  NCDC$Group <- subjectHits(findOverlaps(Overlap, reduce(Overlap)))
  
  library(data.table)
  Events <- as.data.table(NCDC)
  Events <- data.frame(Events[, list(Begin_Date = min(Begin_Date), End_Date = max(End_Date)), by = Group])
  
  Events <- Events[,-1]
  
  Events$Begin_Date <- as.Date.numeric(Events$Begin_Date, origin = "1970-01-01")  #Origin Date for R
  Events$End_Date <- as.Date.numeric(Events$End_Date, origin = "1970-01-01")  #Origin Date for R
  
  return(Events)
}  
